﻿<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl<SearchViewModel>" %>

<div id="searchResultsStatic" class="panel searchResults">
    <%
        var hasRadius = Model.Criteria is AdvancedSearchQuery && ((AdvancedSearchQuery)Model.Criteria).Radius.HasValue;
        var actionName = Model.AdvancedMode ? "Advanced" : "Search";
    %>
    <div class="innerPanel">
        <h2>
            <ul>
                <li><strong>Activities</strong></li>
                <li><%=Html.ActionLink("Itineraries", actionName, Model.Criteria.NewPage(1).NewType(SearchType.Itinerary).GetRouteValues())%></li>
            </ul>
        </h2>
        <div>
            <% if(Model.TotalPages > 0 && !hasRadius) { %>
            <div class="subheader">
                Sort by:
                <% if (Model.Criteria.SortBy == SortCriteria.Relevance)
                   { %>
                    <strong>Relevance</strong>
                <% } else { %>
                    <%=Html.ActionLink("Relevance", actionName, Model.Criteria.NewSortCriteria(SortCriteria.Relevance).NewPage(1).GetRouteValues())%>
                <% } %>
                |
                <% if (Model.Criteria.SortBy == SortCriteria.Rating)
                   { %>
                    <strong>Rating</strong>
                <% } else { %>
                    <%=Html.ActionLink("Rating", actionName, Model.Criteria.NewSortCriteria(SortCriteria.Rating).NewPage(1).GetRouteValues())%>
                <% } %>
                |
                <% if (Model.Criteria.SortBy == SortCriteria.Popularity)
                   { %>
                    <strong>Popularity</strong>
                <% } else { %>
                    <%=Html.ActionLink("Popularity", actionName, Model.Criteria.NewSortCriteria(SortCriteria.Popularity).NewPage(1).GetRouteValues())%>
                <% } %>
            </div>
            <% } %>
            <div class="items">
                <% if(Model.Items == null) %>
                <% { %>
                    <h3>Please provide a search criteria...</h3>
                <% } else { %>
                    <% if(Model.TotalPages == 0) %>
                    <% { %>
                        <h3>No activities found...</h3>
                    <% } else {%>
                        <ul class="activities">
                            <% foreach(var activity in Model.Items as IEnumerable<ActivityViewModel>) %>
                            <% { %>
                            <li>
                                <span class="off id"><%:activity.Entity.Id%></span>
                                <h3>
                                    <span class="rating <%=ActivityHelper.GetRatingCssClass(activity.Entity.Rating)%>"><span>Rating: </span><%=ActivityHelper.GetRatingLabel(activity.Entity.Rating)%></span>
                                    <a href="<%=Html.AttributeEncode(activity.DetailsLink)%>"><%:activity.Entity.Name%></a>
                                </h3>
                                <p><%:activity.Entity.Street%></p>
                                <p><%:activity.Entity.City%>, <%:activity.Entity.State%> | Phone: <%:activity.Entity.PhoneNumber%></p>
                                <p class="options">
                                    <a href="<%=Html.AttributeEncode(activity.ActivityItinerariesLink)%>" class="btn relatedItineraries"  rel="nofollow" title="View itineraries containing this activity">View Itineraries</a>
                                    <a href="<%=Html.AttributeEncode(activity.AddToItineraryLink)%>" class="btn add" rel="nofollow" title="Add to Itinerary">Add to Itinerary</a>
                                    <% if(Ajax.JavaScriptEnabled()) { %><span style="display:none" class="handler">Drag to Add</span><% } %>
                                </p>
                            </li>
                            <% } %>
                        </ul>
                    <% } %>
                <% } %>
            </div>
            
            <div class="toolbox">
            <% if (Model.TotalPages > 0) %>
            <% { %>
                <div class="pager">
                    <% if (string.IsNullOrEmpty(Model.PreviousPageLink)) %>
                    <% { %>
                        « Previous
                    <% } else { %>
                        <a href="<%=Html.AttributeEncode(Model.PreviousPageLink)%>">« Previous</a>
                    <% } %>
                    |
                    <strong>Page <%=Model.CurrentPage%></strong>
                    |
                    <% if (string.IsNullOrEmpty(Model.NextPageLink)) %>
                    <% { %>
                        Next »
                    <% } else { %>
                        <a href="<%=Html.AttributeEncode(Model.NextPageLink)%>">Next »</a>
                    <% } %>
                </div>
            <% } %>
            </div>
        </div>
    </div>
</div>